<?php

namespace Modules\TransactionManagement\Service;

use App\Repository\EloquentRepositoryInterface;
use App\Service\BaseService;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Pagination\LengthAwarePaginator;
use Modules\TransactionManagement\Repository\TransactionRepositoryInterface;
use Modules\TransactionManagement\Service\Interface\TransactionServiceInterface;

class TransactionService extends BaseService implements Interface\TransactionServiceInterface
{
    protected $transactionRepository;

    public function __construct(TransactionRepositoryInterface $transactionRepository)
    {
        parent::__construct($transactionRepository);
        $this->transactionRepository = $transactionRepository;
    }

    public function customerWalletTransaction(array $data, array $relations = [], array $orderBy = [], int $limit = null, int $offset = null): Collection|LengthAwarePaginator|\Illuminate\Support\Collection
    {

        $whereBetweenCriteria = [];
        if (array_key_exists('data', $data) && $data['data'] != ALL_TIME) {
            if ($data['data'] == 'custom_date') {
                $date['start'] = $data['start'];
                $date['end'] = $data['end'];

            } else {
                $date = $data['data'];
            }
            $date = getDateRange($date);
            $whereBetweenCriteria = [
                'created_at' => [$date['start'], $date['end']],
            ];
        }
        $criteria = [
            'account' => 'wallet_balance',
            'attribute' => 'fund_by_admin'
        ];
        $searchCriteria = [
            'fields' => ['id'],
            'value' => $data['search'] ?? ""
        ];
        if (array_key_exists('user_id', $data) && $data['user_id'] != "all") {
            $criteria = array_merge($criteria, [
                'user_id' => $data['user_id']
            ]);
        }

        return $this->transactionRepository
            ->getBy(criteria: $criteria, searchCriteria: $searchCriteria, whereBetweenCriteria: $whereBetweenCriteria, relations: ['user'], orderBy: $orderBy, limit: $limit, offset: $offset, appends: $data);
    }

    public function export(array $criteria = [], array $relations = [], array $orderBy = [], int $limit = null, int $offset = null, array $withCountQuery = []): Collection|LengthAwarePaginator|\Illuminate\Support\Collection
    {
        return $this->index(criteria: $criteria,relations: ['user'],orderBy: ['created_at' => 'desc'],limit: $limit,offset: $offset)->map(function ($item) {
            return [
                'Transaction Id' => $item['id'],
                'Reference' => $item['trx_ref_id'],
                'Type' => ucwords(str_replace("_", ' ', $item['account'])),
                'Transaction Date' => date('d-m-Y h:i A', strtotime($item['created_at'])),
                'Transaction To' => $item->user?->first_name . ' ' . $item->user?->last_name,
                'Credit' => getCurrencyFormat($item['credit']),
                'Debit' => getCurrencyFormat($item['debit']),
                'Balance' => getCurrencyFormat($item['balance']),
            ];
        });
    }

    public function index(array $criteria = [], array $relations = [], array $whereHasRelations = [], array $orderBy = [], int $limit = null, int $offset = null, array $withCountQuery = [], array $appends = [], array $groupBy = []): Collection|LengthAwarePaginator
    {
        $data = [];
        if (array_key_exists('customer_id', $criteria)){
            $data['user_id'] = $criteria['customer_id'];
        }
        if (array_key_exists('driver_id', $criteria)){
            $data['user_id']=$criteria['driver_id'];
        }
        if (array_key_exists('status', $criteria) && $criteria['status'] !== 'all') {
            $data['is_active'] = $criteria['status'] == 'active' ? 1 : 0;
        }
        $searchData = [];
        if (array_key_exists('search', $criteria) && $criteria['search'] != '') {
            $searchData['fields'] = ['id','trx_ref_id','created_at','credit','balance'];
            $searchData['value'] = $criteria['search'];
        }
        $whereInCriteria = [];
        $whereBetweenCriteria = [];
        return $this->transactionRepository->getBy(criteria: $data, searchCriteria: $searchData, whereInCriteria: $whereInCriteria, whereBetweenCriteria: $whereBetweenCriteria, whereHasRelations: $whereHasRelations, relations: $relations, orderBy: $orderBy, limit: $limit, offset: $offset, withCountQuery: $withCountQuery); // TODO: Change the autogenerated stub
    }
}
