<?php

namespace Modules\BusinessManagement\Http\Controllers\Web\Admin\Configuration;

use App\Http\Controllers\BaseController;
use Brian2694\Toastr\Facades\Toastr;
use Illuminate\Database\Eloquent\Collection;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Http\RedirectResponse;
use Illuminate\Http\Request;
use Illuminate\Pagination\LengthAwarePaginator;
use Illuminate\View\View;
use Modules\BusinessManagement\Http\Requests\EmailSettingSetupStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\GoogleMapSetupStoreOrUpdateRequest;
use Modules\BusinessManagement\Http\Requests\RecaptchaSetupStoreOrUpdateRequest;
use Modules\BusinessManagement\Service\Interface\BusinessSettingServiceInterface;

class ThirdPartyController extends BaseController
{
    use AuthorizesRequests;

    protected $businessSettingService;

    public function __construct(BusinessSettingServiceInterface $businessSettingService)
    {
        parent::__construct($businessSettingService);
        $this->businessSettingService = $businessSettingService;
    }

    public function index(?Request $request, string $type = null): View|Collection|LengthAwarePaginator|null|callable|RedirectResponse
    {
        return parent::index($request, $type); // TODO: Change the autogenerated stub
    }

    public function emailConfig()
    {
        $this->authorize('business_view');
        $attributes = ['key_name' => EMAIL_CONFIG,
            'settings_type' => EMAIL_CONFIG];

        $setting = $this->businessSettingService->findOneBy(criteria: $attributes)?->value;

        return view('businessmanagement::admin.configuration.email-config', compact('setting'));
    }

    public function updateEmailConfig(EmailSettingSetupStoreOrUpdateRequest $request)
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeEmailConfig($request->validated());
        Toastr::success(CONFIGURATION_UPDATE_200['message']);
        return back();
    }

    public function recaptcha()
    {
        $this->authorize('business_view');
        $attributes = [
            'settings_type' => RECAPTCHA,
            'key_name' => RECAPTCHA
        ];
        $setting = $this->businessSettingService
            ->findOneBy(criteria: $attributes)?->value;

        return view('businessmanagement::admin.configuration.recapcha', compact('setting'));
    }

    public function updateRecaptcha(RecaptchaSetupStoreOrUpdateRequest $request)
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeRecaptha($request->validated());
        Toastr::success(CONFIGURATION_UPDATE_200['message']);
        return back();
    }

    public function map()
    {
        $this->authorize('business_view');
        $attributes = [
            'settings_type' => GOOGLE_MAP_API,
            'key_name' => GOOGLE_MAP_API
        ];
        $setting = $this->businessSettingService
            ->findOneBy(criteria: $attributes)?->value;
        return view('businessmanagement::admin.configuration.google-map', compact('setting'));
    }

    public function updateMap(GoogleMapSetupStoreOrUpdateRequest $request)
    {
        $this->authorize('business_edit');
        $this->businessSettingService->storeGoogleMapApi($request->validated());
        Toastr::success(CONFIGURATION_UPDATE_200['message']);
        return back();
    }
}
